<?php

namespace App/Models/Transportations;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transportation extends Eloquent {

	protected $table = 'transportations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'phone', 'address', 'email');
	protected $visible = array('name', 'phone', 'address', 'email');

	public function paymentTerms()
	{
		return $this->belongsTo('PaymentTerm');
	}

	public function vehicleType()
	{
		return $this->belongsTo('VehicleType');
	}

	public function documents()
	{
		return $this->morphMany('Document');
	}

}