<?php

namespace App/Models/Vendor;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model 
{

    protected $table = 'vendors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('sub_dispatch_id', 'name', 'address', 'payment_term_id', 'pickup_address', 'email');
    protected $visible = array('sub_dispatch_id', 'name', 'address', 'payment_term_id', 'pickup_address', 'email');

    public function paymentTerms()
    {
        return $this->belongsTo('PaymentTerm');
    }

    public function documents()
    {
        return $this->morphMany('Document');
    }

}