<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAutomatismsTable extends Migration {

	public function up()
	{
		Schema::create('automatisms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->enum('type', array('birthday', 'recurring'));
			$table->boolean('send_to_all');
			$table->text('data');
			$table->enum('state', array('enabled', 'disabled'));
		});
	}

	public function down()
	{
		Schema::drop('automatisms');
	}
}