<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Homework extends Model 
{

    protected $table = 'homework';
    public $timestamps = true;

    public function students()
    {
        return $this->belongsToMany('HomworkStudent', 'student_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function lecture()
    {
        return $this->belongsTo('Lecture', 'lecture_id');
    }

    public function course()
    {
        return $this->belongsTo('Course', 'course_id');
    }

    public function files()
    {
        return $this->hasMany('File', 'homework_id');
    }

    public function studentFiles()
    {
        return $this->hasMany('Student_files', 'student_id');
    }

}