<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFRAMESTable extends Migration {

	public function up()
	{
		Schema::create('FRAMES', function(Blueprint $table) {
			$table->increments('id');
			$table->string('frame_title', 60);
			$table->string('frame_description', 255);
			$table->integer('userID')->unsigned()->index();
			$table->integer('planID')->unsigned()->index();
			$table->enum('status', array('archived', 'deleted', 'active'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('FRAMES');
	}
}