<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('branch_id')->unsigned();
			$table->string('email');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->integer('from_id')->unsigned();
			$table->integer('to_id')->unsigned()->nullable();
			$table->string('subject')->nullable();
			$table->longText('message');
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}