<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->uuid('id');
			$table->string('name');
			$table->string('SKU');
			$table->float('price');
			$table->integer('quantity');
			$table->uuid('order_id');
			$table->integer('type');
			$table->string('reason_return', 200)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}