<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInboundShipmentsTable extends Migration {

	public function up()
	{
		Schema::create('inbound_shipments', function(Blueprint $table) {
			$table->uuid('id')->primary();
			$table->date('receiving_date');
			$table->string('receiving_time', 200);
			$table->uuid('item_type_id');
			$table->string('boxes_pallets', 50);
			$table->uuid('user_id')->default('10');
			$table->uuid('merchant_id');
			$table->integer('status')->default('0');
			$table->string('shipment_number', 10)->unique();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inbound_shipments');
	}
}