<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('category_translations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('parameters', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('parameter_translations', function(Blueprint $table) {
			$table->foreign('parameter_id')->references('id')->on('parameters')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('parameter_items', function(Blueprint $table) {
			$table->foreign('parameter_id')->references('id')->on('parameters')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('coins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('category_translations', function(Blueprint $table) {
			$table->dropForeign('category_translations_category_id_foreign');
		});
		Schema::table('parameters', function(Blueprint $table) {
			$table->dropForeign('parameters_category_id_foreign');
		});
		Schema::table('parameter_translations', function(Blueprint $table) {
			$table->dropForeign('parameter_translations_parameter_id_foreign');
		});
		Schema::table('parameter_items', function(Blueprint $table) {
			$table->dropForeign('parameter_items_parameter_id_foreign');
		});
		Schema::table('coins', function(Blueprint $table) {
			$table->dropForeign('coins_user_id_foreign');
		});
	}
}