<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191);
			$table->string('link', 191);
			$table->text('body');
			$table->text('excerpt')->nullable();
			$table->string('image', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}