<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('title');
			$table->string('content');
			$table->longText('other');
			$table->string('slug');
			$table->tinyInteger('footer_menu')->default('0');
			$table->tinyInteger('header_menu')->default('0');
			$table->tinyInteger('sidebar_menu')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}