<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriversTable extends Migration {

	public function up()
	{
		Schema::create('drivers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('car')->unsigned();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('contact_address');
			$table->string('billing_address');
			$table->string('date_of_birth');
			$table->string('identification_number');
			$table->string('member_status');
			$table->string('email_status');
			$table->string('phone_status');
			$table->string('driver_lisance_no');
			$table->string('driver_lisance_front');
			$table->string('driver_lisance_back');
			$table->string('driver_score')->default('5');
			$table->string('driver_balance');
			$table->string('last_location');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('drivers');
	}
}