<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_purchase', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_purchase', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_purchase', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admin_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_activity', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_activity', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_report', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_report', function(Blueprint $table) {
			$table->foreign('purchase_id')->references('id')->on('user_purchase')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_report', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('all_notifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('purchase_id')->references('id')->on('user_purchase')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('perm_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('razorpay_response_parent', function(Blueprint $table) {
			$table->foreign('order_response_id')->references('order_id')->on('razorpay_request_parent')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_event_id_foreign');
		});
		Schema::table('user_purchase', function(Blueprint $table) {
			$table->dropForeign('user_purchase_user_id_foreign');
		});
		Schema::table('user_purchase', function(Blueprint $table) {
			$table->dropForeign('user_purchase_event_id_foreign');
		});
		Schema::table('user_purchase', function(Blueprint $table) {
			$table->dropForeign('user_purchase_category_id_foreign');
		});
		Schema::table('admin_user', function(Blueprint $table) {
			$table->dropForeign('admin_user_role_id_foreign');
		});
		Schema::table('user_activity', function(Blueprint $table) {
			$table->dropForeign('user_activity_user_id_foreign');
		});
		Schema::table('user_activity', function(Blueprint $table) {
			$table->dropForeign('user_activity_category_id_foreign');
		});
		Schema::table('payment_report', function(Blueprint $table) {
			$table->dropForeign('payment_report_user_id_foreign');
		});
		Schema::table('payment_report', function(Blueprint $table) {
			$table->dropForeign('payment_report_purchase_id_foreign');
		});
		Schema::table('payment_report', function(Blueprint $table) {
			$table->dropForeign('payment_report_category_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_notification_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_purchase_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_role_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_perm_id_foreign');
		});
		Schema::table('razorpay_response_parent', function(Blueprint $table) {
			$table->dropForeign('razorpay_response_parent_order_response_id_foreign');
		});
	}
}