<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCaseAfterSettlementTable extends Migration {

	public function up()
	{
		Schema::create('legal_case_after_settlement', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('legal_case_id')->unsigned();
			$table->boolean('gas_plan');
			$table->boolean('internet_plan');
			$table->boolean('electricity_plan');
			$table->text('consent_form_pdf_path')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('legal_case_after_settlement');
	}
}