<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('components', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('components', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('assigned_to')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('components')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->foreign('assigned_to')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->foreign('component_id')->references('id')->on('components')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_created_by_foreign');
		});
		Schema::table('components', function(Blueprint $table) {
			$table->dropForeign('components_project_id_foreign');
		});
		Schema::table('components', function(Blueprint $table) {
			$table->dropForeign('components_created_by_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_created_by_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_assigned_to_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_component_id_foreign');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->dropForeign('bugs_created_by_foreign');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->dropForeign('bugs_assigned_to_foreign');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->dropForeign('bugs_task_id_foreign');
		});
		Schema::table('bugs', function(Blueprint $table) {
			$table->dropForeign('bugs_component_id_foreign');
		});
	}
}