<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->longText('description');
			$table->enum('status', array('Pending', 'InProgress', 'Done'));
			$table->date('start_date');
			$table->date('end_date');
			$table->string('srs_file');
			$table->string('image')->nullable();
			$table->integer('created_by')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}