<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function customer()
	{
		return $this->belongsTo('App\Model\Customer');
	}

	public function events()
	{
		return $this->hasMany('App\Model\Event');
	}

}