<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'start_date', 'end_date');

	public function location()
	{
		return $this->belongsTo('App\Model\Location');
	}

	public function customer()
	{
		return $this->belongsTo('App\Model\Customer');
	}

	public function tracks()
	{
		return $this->hasMany('App\Model\Place');
	}

}