<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Actor extends Eloquent {

	protected $table = 'actors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'display_name', 'photo', 'team_id', 'customer_id');

	public function customer()
	{
		return $this->belongsTo('App\Model\Customer');
	}

	public function team()
	{
		return $this->belongsTo('App\Model\Team');
	}

}