<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Act extends Eloquent {

	protected $table = 'acts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'start_datetime', 'end_datetime');

	public function track()
	{
		return $this->belongsTo('App\Model\Place');
	}

	public function customer()
	{
		return $this->belongsTo('App\Model\Customer');
	}

	public function act_configuration()
	{
		return $this->hasOne('ActConfiguration');
	}

	public function player_ads()
	{
		return $this->hasMany('PlayerAd');
	}

}