<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransmissionBoxesTable extends Migration {

	public function up()
	{
		Schema::create('transmission_boxes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('subdomain')->nullable();
			$table->string('type')->nullable();
			$table->string('stream_url');
			$table->integer('customer_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('transmission_boxes');
	}
}