<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActorsTable extends Migration {

	public function up()
	{
		Schema::create('actors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('display_name')->nullable();
			$table->smallInteger('number')->nullable();
			$table->string('photo')->nullable();
			$table->integer('team_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('actors');
	}
}