<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketSettingsTable extends Migration {

	public function up()
	{
		Schema::create('ticket_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('auto_reply')->default(true);
			$table->string('auto_reply_subject')->default('Re : {%subject%}');
			$table->longText('auto_reply_message');
			$table->string('status_after_reply')->default('active');
			$table->text('signature');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ticket_settings');
	}
}