<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('plans', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('payment_gateway_id')->references('id')->on('payment_gateways')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plan_feature', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_feature', function(Blueprint $table) {
			$table->foreign('feature_id')->references('id')->on('features')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('post_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('comments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coupon_usages', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('affiliates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('affiliate_commissions', function(Blueprint $table) {
			$table->foreign('affiliate_id')->references('id')->on('affiliates')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('post_views', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('plans', function(Blueprint $table) {
			$table->dropForeign('plans_user_id_foreign');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->dropForeign('payment_plans_plan_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_subscription_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_user_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_plan_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_payment_gateway_id_foreign');
		});
		Schema::table('plan_feature', function(Blueprint $table) {
			$table->dropForeign('plan_feature_plan_id_foreign');
		});
		Schema::table('plan_feature', function(Blueprint $table) {
			$table->dropForeign('plan_feature_feature_id_foreign');
		});
		Schema::table('post_categories', function(Blueprint $table) {
			$table->dropForeign('post_categories_parent_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_parent_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('coupon_usages', function(Blueprint $table) {
			$table->dropForeign('coupon_usages_coupon_id_foreign');
		});
		Schema::table('affiliates', function(Blueprint $table) {
			$table->dropForeign('affiliates_user_id_foreign');
		});
		Schema::table('affiliate_commissions', function(Blueprint $table) {
			$table->dropForeign('affiliate_commissions_affiliate_id_foreign');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->dropForeign('post_tag_post_id_foreign');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->dropForeign('post_tag_tag_id_foreign');
		});
		Schema::table('post_views', function(Blueprint $table) {
			$table->dropForeign('post_views_post_id_foreign');
		});
	}
}