<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->double('rating');
			$table->text('review');
			$table->boolean('is_featured')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}