<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('title', 255);
			$table->longText('description')->nullable();
			$table->longText('available_features');
			$table->longText('not_available_features')->nullable();
			$table->double('trial_period')->nullable();
			$table->double('monthly_price')->nullable();
			$table->double('annual_price')->nullable();
			$table->double('lifetime_price')->nullable();
			$table->double('monthly_discount')->nullable();
			$table->boolean('is_paid')->default(true);
			$table->boolean('status')->default(status);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}