<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAffiliateVisitsTable extends Migration {

	public function up()
	{
		Schema::create('affiliate_visits', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('affiliate_id')->unsigned();
			$table->string('session_id')->nullable();
			$table->string('visitor_ip');
			$table->timestamp('visited_at');
			$table->boolean('converted')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('affiliate_visits');
	}
}