<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('middle_name', 255)->nullable();
			$table->string('last_name', 255);
			$table->string('email', 255)->unique();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password');
			$table->string('phone')->nullable();
			$table->enum('type', array('admin', 'user'));
			$table->string('lang')->nullable();
			$table->enum('status', array('active', 'banned'));
			$table->string('remember_token')->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->bigInteger('current_team_id')->unsigned();
			$table->string('profile_photo_path', 2048)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}