<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('fundrequests', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('client_installments', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('client_installments', function(Blueprint $table) {
			$table->foreign('fund_id')->references('id')->on('fundrequests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('fundrequests', function(Blueprint $table) {
			$table->dropForeign('fundrequests_client_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_client_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_user_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_role_id_foreign');
		});
		Schema::table('client_installments', function(Blueprint $table) {
			$table->dropForeign('client_installments_client_id_foreign');
		});
		Schema::table('client_installments', function(Blueprint $table) {
			$table->dropForeign('client_installments_fund_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_client_id_foreign');
		});
	}
}