<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->string('user_number', 50)->nullable();
			$table->integer('phone')->nullable();
			$table->string('email', 100)->nullable();
			$table->string('password', 50)->nullable();
			$table->string('verify_code', 10)->nullable();
			$table->integer('national_id');
			$table->integer('type');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}