<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('national_id')->default('0');
			$table->string('name', 255)->nullable();
			$table->string('phone', 50)->nullable();
			$table->string('alam_code', 10)->nullable();
			$table->integer('status')->default('0');
			$table->integer('password')->nullable();
			$table->integer('use_password')->default('0');
			$table->date('dob')->nullable();
			$table->string('email', 255)->nullable();
			$table->string('salary_month', 20)->nullable();
			$table->string('monthly_commitments', 20)->nullable();
			$table->string('salary_file', 150)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}