<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDossierTable extends Migration {

	public function up()
	{
		Schema::create('dossier', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('numpr');
			$table->integer('service_id')->unsigned();
			$table->smallInteger('annee');
			$table->integer('nature_affaire_id')->unsigned();
			$table->integer('pays_id')->unsigned();
			$table->integer('redacteur_id')->unsigned();
			$table->integer('magistrat_id')->unsigned();
			$table->integer('mandataire_id')->unsigned();
			$table->date('date_creation');
			$table->string('date_maj');
			$table->boolean('fin_affaire')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('dossier');
	}
}