<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServerTable extends Migration {

	public function up()
	{
		Schema::create('server', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->index();
			$table->string('number', 255)->index();
			$table->string('number_code', 255)->index()->default('+98');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('server');
	}
}