<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('doctor_subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('doctor_id')->unsigned();
			$table->string('subscription_period', 32);
			$table->double('total_amount');
			$table->double('tax');
			$table->integer('payment_method_id')->unsigned();
			$table->integer('subscription_package_id')->unsigned();
			$table->integer('created_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctor_subscriptions');
	}
}