<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name', 64);
			$table->string('username', 32)->nullable();
			$table->string('password', 80)->nullable();
			$table->string('email', 64)->nullable();
			$table->string('phone_number', 16)->unique();
			$table->string('gender', 64)->nullable();
			$table->integer('age')->nullable();
			$table->date('dob');
			$table->string('blood_group', 8)->nullable();
			$table->string('father_name', 64)->nullable();
			$table->string('mother_name', 64)->nullable();
			$table->text('adress')->nullable();
			$table->text('note')->nullable();
			$table->text('bio')->nullable();
			$table->string('avatar', 60)->nullable();
			$table->integer('created_by')->nullable();
			$table->integer('updated_by')->nullable();
			$table->rememberToken();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}