<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Account extends Eloquent {

	protected $table = 'accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'platform_id', 'name', 'bin_code', 'gender', 'area_id', 'age', 'messages', 'wish');

	public function Area()
	{
		return $this->belongsTo('App\Area', 'area_id');
	}

	public function Platform()
	{
		return $this->belongsTo('App\Platforms', 'platform_id');
	}

	public function User()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function Transfer()
	{
		return $this->belongsTo('App\Transfer', 'transfer_id');
	}

	public function Vias()
	{
		return $this->hasMany('App\Via', 'acc_id');
	}

}