<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nom', 255);
			$table->string('prenom', 255);
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->date('birthday')->nullable();
			$table->integer('active')->default('0');
			$table->string('phone', 255)->nullable();
			$table->string('metier', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}