<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TherapistPackages extends Eloquent {

	protected $table = 'therapist_packages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'therapy_type_id', 'number_of_sessions', 'price', 'therapist_id');
	protected $visible = array('name', 'number_of_sessions', 'price');

	public function session()
	{
		return $this->hasOne('TherapyTypes', 'therapy_type_id', 'id');
	}

}