<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersLocationsTable extends Migration {

	public function up()
	{
		Schema::create('users_locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('official_name', 255);
			$table->string('customized_name', 255);
			$table->string('address', 500);
			$table->string('city', 255);
			$table->string('country', 255);
			$table->string('postal_code', 255);
			$table->string('website', 255);
			$table->string('phone', 255);
			$table->integer('user_id')->unsigned();
			$table->decimal('price_per_session', 8,2);
		});
	}

	public function down()
	{
		Schema::drop('users_locations');
	}
}