<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('drink', 'article', 'dish');

	public function products()
	{
		return $this->hasMany('app\Product');
	}

}