<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nik', 191)->unique();
			$table->string('full_name', 191);
			$table->integer('user_id');
			$table->integer('department_id');
			$table->integer('position_id');
			$table->datetime('date_joined');
			$table->datetime('date_end')->nullable();
			$table->string('gender', 25);
			$table->date('date_birth');
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}