<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Events extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('profile_id', 'type_id', 'location_id', 'code', 'name');

    public function location()
    {
        return $this->hasOne('Location');
    }

    public function type()
    {
        return $this->hasOne('EventType');
    }

    public function protocol()
    {
        return $this->belongsTo('\Protocol')->withPivot('protocol_events');
    }

    public function owner()
    {
        return $this->belongsTo('Profile');
    }

    public function groups()
    {
        return $this->hasMany('Groups');
    }

}