<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255)->index();
			$table->string('last_name', 255)->index();
			$table->integer('role_id')->unsigned();
			$table->string('password', 255)->index();
			$table->string('user_image', 255)->index();
			$table->integer('created_by')->unsigned()->default('0');
			$table->datetime('created_date');
			$table->integer('modified_by')->unsigned()->default('0');
			$table->datetime('modified_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}