<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserContactDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_contact_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('contact_value', 255)->index();
			$table->integer('created_by')->unsigned();
			$table->datetime('created_date');
			$table->integer('contact_type_id')->unsigned();
			$table->integer('modified_by')->unsigned();
			$table->datetime('modified_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_contact_details');
	}
}