<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStateTable extends Migration {

	public function up()
	{
		Schema::create('state', function(Blueprint $table) {
			$table->increments('id');
			$table->char('state_abbr', 4)->index();
			$table->string('state_name');
			$table->integer('country_id');
			$table->integer('dealer_id')->unsigned()->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('state');
	}
}