<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerLicenseInfoTable extends Migration {

	public function up()
	{
		Schema::create('customer_license_info', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->string('license_number', 255)->index();
			$table->integer('license_issuing_state')->unsigned();
			$table->date('license_expiry_date')->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customer_license_info');
	}
}