<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerCcInfoTable extends Migration {

	public function up()
	{
		Schema::create('customer_cc_info', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('customer_id')->unsigned();
			$table->string('cc_type', 255);
			$table->string('cc_name', 255)->index();
			$table->string('cc_number', 255);
			$table->char('cc_cvc', 5);
			$table->date('cc_expiry');
			$table->string('vault_id')->nullable();
			$table->string('cc_encrypt_value')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customer_cc_info');
	}
}