<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_services()
    {
        return $this->hasMany('User_Service');
    }

    public function payments()
    {
        return $this->hasMany('Payment');
    }

    public function requests()
    {
        return $this->hasMany('Request');
    }

    public function invoices()
    {
        return $this->hasMany('Invoices');
    }

    public function role()
    {
        return $this->belongsTo('Roles');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}