<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->integer('id_user')->unsigned();
			$table->integer('id_agen')->unsigned();
			$table->integer('jumlah');
			$table->integer('harga_beli');
			$table->string('pembayaran', 20);
			$table->string('status', 10);
			$table->text('deskripsi');
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}