<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactTable extends Migration {

	public function up()
	{
		Schema::create('contact', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email1')->nullable();
			$table->string('email2')->nullable();
			$table->string('phone1')->nullable();
			$table->string('phone2')->nullable();
			$table->double('latitude')->nullable();
			$table->double('longitude')->nullable();
			$table->text('address')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contact');
	}
}